clear;close all;

% get parameters and variable indices
params = setParams();
[vrbs, shocks, nvar, nstate, nshock] = defineModel();

% Initialize canonical-form matrices (which we will later populate)
A0=zeros(nstate,nstate);
A1=zeros(nstate,nstate);
A2=zeros(nstate,nstate);
A3=zeros(nstate,nstate);
A4=zeros(nstate,nstate);
A5=zeros(nstate,nstate);
A6=zeros(nstate,nstate);

%% Firm's Decision
firms=struct;

% set number of variables
firms.nvar  = 3;
firms.nstate= 1;

% assign indices to relevant state variables
firms.i     = 1;
firms.P_K   = 2;
firms.i_lag = 3;

% Define Psi_0 and Psi_1 matrices
firms.Psi_0 = zeros(firms.nvar,firms.nvar);
firms.Psi_1 = zeros(firms.nvar,firms.nvar);

firms.Psi_0(firms.i,firms.i)          = -params.beta*params.gamma^(1-params.sigma);
firms.Psi_0(firms.P_K,firms.P_K)      = params.beta*params.gamma^(1-params.sigma)*(1-params.delta);
firms.Psi_0(firms.i_lag,firms.i_lag)  = 1;

firms.Psi_1(firms.i,firms.i)          = -(1+params.beta*params.gamma^(1-params.sigma));
firms.Psi_1(firms.i,firms.P_K)        = params.xi_I;
firms.Psi_1(firms.i,firms.i_lag)      = 1;
firms.Psi_1(firms.P_K,firms.P_K)      = 1;
firms.Psi_1(firms.i_lag,firms.i)      = 1;

% get decision rule
[firms.Dk, firms.Dd1, firms.Dd2, firms.Lambda] = getDecision(firms.Psi_0,firms.Psi_1,firms.nstate);
firms.Dl4=firms.Dd1*[firms.Dd2(1,:);zeros(1,firms.nvar)];
firms.Dl5=firms.Dd1*[zeros(1,firms.nvar);firms.Dd2(2,:)];
firms.lambda_4=firms.Lambda(1,1);
firms.lambda_5=firms.Lambda(2,2);

% populate canonical-form matrices matrices
A0(1,vrbs.mu)=firms.Dl4(1,1)*params.xi_I;
A0(1,vrbs.gamma)=firms.Dl4(1,1)*(params.beta*params.gamma^(1-params.sigma)*params.rho_gamma-1);
